package com.izenpe.zain.cliente.ts;

import org.apache.axis.encoding.Base64;

import com.izenpe.zain.client.ZainConfig;
import com.izenpe.zain.cliente.util.CalcularHash;
import com.izenpe.zain.cliente.util.Constantes;
import com.izenpe.zain.cliente.util.Propiedades;
import com.izenpe.zain.cliente.util.ZainUtil;
import com.safelayer.trustedx.client.smartwrapper.Constants;
import com.safelayer.trustedx.client.smartwrapper.SmartVerifyRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartVerifyResponse;

public class VerificacionFirmaTS {
	// Nombre del fichero cuya firma va a ser verificada.
	private static final String tsName = "HelloWorld.tst";
	private static final String fileName = "HelloWorld.txt";
	
	public static void main(String args[]) {
		try {

			ZainConfig.setCurrent(Propiedades.ZAIN_CONFIG);
			/*
			 * Se crea la peticin a travs de la URL definida en ZAIN_ENDPOINT.
			 */
			SmartVerifyRequest smartVerifyReq = new SmartVerifyRequest(Propiedades.ZAIN_ENDPOINT);

			// Se establece el perfil de sello de tiempo en la peticin de Verificacin
			// de firma.
			smartVerifyReq.setProfile(Constants.Profile.TIMESTAMPING);

			/*
			 * Se establece el idioma de la peticin en espaol. 2
			 * posibilidades: 1. Espaol: 'es' 2. Ingls: 'en'
			 */
			smartVerifyReq.setLanguage("es");

			// Datos a verificar. pasamos el documento original
//			smartVerifyReq.setInputBase64Data(Base64.encode(ZainUtil.readBinaryFile("data/input/" + fileName)));
			
			// Datos a firmar. pasamos el hash documento original
			//smartSignReq.setInputBase64Data(Base64.encode(ZainUtil.readBinaryFile("data/input/" + fileName)));
			smartVerifyReq.setInputHashAlgorithm(Constants.DigestAlgorithm.SHA1);
			String hashDoc = CalcularHash.getHash("data/input/" + fileName);
			smartVerifyReq.setInputHashDigest(hashDoc);
			
			smartVerifyReq.setTimeStamp(Base64.encode(ZainUtil.readBinaryFile("data/output/" + tsName)));


			// Envo de la peticin.
			SmartVerifyResponse smartVerifyResp = smartVerifyReq.send();

			// Se comprueba la validez de la respuesta de Verificacin de firma
			// PDF
			if (Constantes.RMAJOR_SUCCESS.equals((smartVerifyResp.getResultMajor()))
					&& Constantes.RMINOR_SUCCESS.equals(smartVerifyResp.getResultMinor())) {
				System.out.println("La firma ha sido verificada con xito.");
			} else {
				System.out.println("La firma tiene errores: " + smartVerifyResp.getResultMessage());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}